/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.apps;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.swing.JAppletFrame;
import com.jsyn.swing.PortControllerFactory;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.LinearRamp;
import com.jsyn.unitgen.SineOscillator;
import com.jsyn.unitgen.UnitOscillator;
import java.awt.GridLayout;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AboutJSyn
extends JApplet {
    private static final long serialVersionUID = -2704222221111608377L;
    private Synthesizer synth;
    private UnitOscillator osc1;
    private UnitOscillator osc2;
    private LinearRamp lag;
    private LineOut lineOut;

    @Override
    public void init() {
        this.synth = JSyn.createSynthesizer();
        this.osc1 = new SineOscillator();
        this.synth.add(this.osc1);
        this.osc2 = new SineOscillator();
        this.synth.add(this.osc2);
        this.lag = new LinearRamp();
        this.synth.add(this.lag);
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.osc1.output.connect(0, this.lineOut.input, 0);
        this.osc2.output.connect(0, this.lineOut.input, 1);
        this.setLayout(new GridLayout(0, 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 1));
        jPanel.add(new JLabel("About: " + this.synth, 0));
        jPanel.add(new JLabel("From: http://www.softsynth.com/", 0));
        jPanel.add(new JLabel("(C) 1997-2011 Mobileer Inc", 0));
        this.add(jPanel);
        this.lag.output.connect(this.osc1.amplitude);
        this.lag.output.connect(this.osc2.amplitude);
        this.lag.input.setup(0.001, 0.5, 1.0);
        this.lag.time.set(0.1);
        this.lag.input.setName("Amplitude");
        this.add(PortControllerFactory.createExponentialPortSlider(this.lag.input));
        this.osc1.frequency.setup(50.0, 300.0, 3000.0);
        this.osc1.frequency.setName("Frequency (Left)");
        this.add(PortControllerFactory.createExponentialPortSlider(this.osc1.frequency));
        this.osc2.frequency.setup(50.0, 302.0, 3000.0);
        this.osc2.frequency.setName("Frequency (Right)");
        this.add(PortControllerFactory.createExponentialPortSlider(this.osc2.frequency));
        this.validate();
    }

    @Override
    public void start() {
        this.synth.start();
        this.lineOut.start();
    }

    @Override
    public void stop() {
        this.synth.stop();
    }

    public static void main(String[] stringArray) {
        AboutJSyn aboutJSyn = new AboutJSyn();
        JAppletFrame jAppletFrame = new JAppletFrame("About JSyn", aboutJSyn);
        jAppletFrame.setSize(440, 300);
        jAppletFrame.setVisible(true);
        jAppletFrame.test();
    }
}

