/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow;

import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.NativeWindow;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.ToolkitLock;
import java.lang.reflect.Constructor;
import jogamp.nativewindow.NullToolkitLock;

public class NativeWindowFactoryImpl
extends NativeWindowFactory {
    private static final ToolkitLock nullToolkitLock = new NullToolkitLock();
    private Constructor<?> nativeWindowConstructor = null;

    public static ToolkitLock getNullToolkitLock() {
        return nullToolkitLock;
    }

    @Override
    protected NativeWindow getNativeWindowImpl(Object object, AbstractGraphicsConfiguration abstractGraphicsConfiguration) throws IllegalArgumentException {
        if (object instanceof NativeWindow) {
            return (NativeWindow)object;
        }
        if (null == abstractGraphicsConfiguration) {
            throw new IllegalArgumentException("AbstractGraphicsConfiguration is null with a non NativeWindow object");
        }
        if (NativeWindowFactory.isAWTAvailable() && ReflectionUtil.instanceOf(object, "java.awt.Component")) {
            return this.getAWTNativeWindow(object, abstractGraphicsConfiguration);
        }
        throw new IllegalArgumentException("Target window object type " + object.getClass().getName() + " is unsupported; expected com.jogamp.nativewindow.NativeWindow or " + "java.awt.Component");
    }

    private NativeWindow getAWTNativeWindow(Object object, AbstractGraphicsConfiguration abstractGraphicsConfiguration) {
        if (this.nativeWindowConstructor == null) {
            try {
                String string;
                String string2 = NativeWindowFactoryImpl.getNativeWindowType(true);
                if (TYPE_WINDOWS == string2) {
                    string = "jogamp.nativewindow.jawt.windows.WindowsJAWTWindow";
                } else if (TYPE_MACOSX == string2) {
                    string = "jogamp.nativewindow.jawt.macosx.MacOSXJAWTWindow";
                } else if (TYPE_X11 == string2) {
                    string = "jogamp.nativewindow.jawt.x11.X11JAWTWindow";
                } else {
                    throw new IllegalArgumentException("Native windowing type " + string2 + " (custom) not yet supported, platform reported native windowing type: " + NativeWindowFactoryImpl.getNativeWindowType(false));
                }
                this.nativeWindowConstructor = ReflectionUtil.getConstructor(string, new Class[]{Object.class, AbstractGraphicsConfiguration.class}, true, this.getClass().getClassLoader());
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception);
            }
        }
        try {
            return (NativeWindow)this.nativeWindowConstructor.newInstance(object, abstractGraphicsConfiguration);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }
}

