/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import com.jsyn.ports.UnitOutputPort;
import processing.core.PApplet;
import processing.sound.Engine;
import processing.sound.SoundObject;

abstract class Analyzer {
    protected SoundObject input;

    protected Analyzer(PApplet pApplet) {
        Engine.getEngine(pApplet);
    }

    public void input(SoundObject soundObject) {
        if (this.input == soundObject) {
            Engine.printWarning("This input was already connected to the analyzer");
        } else {
            if (this.input != null) {
                if (!this.input.isPlaying()) {
                    Engine.getEngine().remove(this.input.circuit);
                }
                this.removeInput();
            }
            this.input = soundObject;
            if (!this.input.isPlaying()) {
                Engine.getEngine().add(soundObject.circuit);
            }
            this.setInput(soundObject.circuit.output.output);
        }
    }

    protected abstract void removeInput();

    protected abstract void setInput(UnitOutputPort var1);
}

