/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import com.jsyn.unitgen.ChannelIn;
import com.jsyn.unitgen.Multiply;
import processing.core.PApplet;
import processing.sound.AndroidPermissionException;
import processing.sound.Engine;
import processing.sound.JSynAndroidAudioDeviceManager;
import processing.sound.JSynCircuit;
import processing.sound.SoundObject;

public class AudioIn
extends SoundObject {
    private ChannelIn input;
    private Multiply multiplier;
    private static final String ANDROID_PERMISSION_WARNING_MESSAGE = "sketch does not have permission to record audio from microphone,\nplease request the permission in your AndroidManifest.xml and in\nyour sketch initialization code (the Sound library's\nAudioInputAndroid example demonstrates how to do both)\n";

    public AudioIn(PApplet pApplet) {
        this(pApplet, 0);
    }

    public AudioIn(PApplet pApplet, int n) {
        super(pApplet);
        if (Engine.getAudioManager() instanceof JSynAndroidAudioDeviceManager) {
            if (n != 0) {
                Engine.printWarning("if you want to capture audio from somewhere other than the default\ndevice on Android, use: new Sound(this).inputDevice(deviceID)\nwhere for deviceID you can fill in any of Android's MediaRecorder.AudioSource constants.");
            }
            if (!pApplet.hasPermission("android.permission.RECORD_AUDIO")) {
                Engine.printError(ANDROID_PERMISSION_WARNING_MESSAGE);
                throw new AndroidPermissionException("RECORD_AUDIO permission not granted");
            }
            Engine.printMessage("capturing audio in from device " + Engine.getSelectedInputDeviceName());
        }
        this.input = new ChannelIn(n);
        this.multiplier = new Multiply();
        this.multiplier.inputA.connect(this.input.output);
        this.amplitude = this.multiplier.inputB;
        this.multiplier.inputB.set(1.0);
        this.circuit = new JSynCircuit(this.multiplier.output);
        this.circuit.add(this.input);
    }

    @Override
    public void play() {
        super.play();
    }

    public void play(float f) {
        this.amp(f);
        this.play();
    }

    public void play(float f, float f2) {
        this.add(f2);
        this.play(f);
    }

    public void play(float f, float f2, float f3) {
        this.set(f, f2, f3);
        this.play();
    }

    public void start() {
        Engine.getEngine().add(this.circuit);
    }

    public void start(float f) {
        this.amp(f);
        this.start();
    }

    public void start(float f, float f2) {
        this.add(f2);
        this.start(f);
    }

    public void start(float f, float f2, float f3) {
        this.set(f, f2, f3);
        this.start();
    }

    public void set(float f, float f2, float f3) {
        this.amp(f);
        this.add(f2);
        this.pan(f3);
    }
}

