/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import com.jsyn.engine.SynthesisEngine;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.ports.UnitVariablePort;
import com.jsyn.unitgen.UnitGenerator;
import processing.core.PApplet;
import processing.sound.Analyzer;
import processing.sound.Engine;

public class BeatDetector
extends Analyzer {
    private final BeatDetectorUGen detector = new BeatDetectorUGen();

    public BeatDetector(PApplet pApplet) {
        super(pApplet);
    }

    @Override
    protected void removeInput() {
        this.input = null;
    }

    @Override
    protected void setInput(UnitOutputPort unitOutputPort) {
        Engine.getEngine().add(this.detector);
        this.detector.start();
        this.detector.input.connect(unitOutputPort);
    }

    public boolean isBeat() {
        return this.detector.current.getValue() == 1.0;
    }

    public void sensitivity(int n) {
        this.detector.sensitivity.set(n);
    }

    public int sensitivity() {
        return (int)this.detector.sensitivity.get();
    }

    public double[] getEnergyBuffer() {
        return this.detector.getEnergyBuffer();
    }

    public int getEnergyCursor() {
        return this.detector.getEnergyCursor();
    }

    public boolean[] getBeatBuffer() {
        return this.detector.getBeatBuffer();
    }

    public class BeatDetectorUGen
    extends UnitGenerator {
        private static final int CHUNK_SIZE = 1024;
        public UnitInputPort input = new UnitInputPort("Input");
        public UnitVariablePort current;
        public UnitInputPort sensitivity;
        public UnitOutputPort output;
        private final double[] audioBuffer;
        private double[] energyBuffer;
        private double[] deltaBuffer;
        private boolean[] beatBuffer;
        private int audioBufferCursor;
        private int energyBufferCursor;
        private long detectTimeMillis;
        private long sensitivityTimer;

        public BeatDetectorUGen() {
            this.addPort(this.input);
            this.current = new UnitVariablePort("Current");
            this.addPort(this.current);
            this.output = new UnitOutputPort("Output");
            this.addPort(this.output);
            this.sensitivity = new UnitInputPort("Sensitivity");
            this.addPort(this.sensitivity);
            this.sensitivity.set(10.0);
            this.audioBuffer = new double[1024];
        }

        @Override
        public void setSynthesisEngine(SynthesisEngine synthesisEngine) {
            super.setSynthesisEngine(synthesisEngine);
            int n = synthesisEngine.getFrameRate();
            int n2 = n / 1024;
            this.energyBuffer = new double[n2];
            this.deltaBuffer = new double[n2];
            this.beatBuffer = new boolean[n2];
        }

        @Override
        public void generate(int n, int n2) {
            double[] dArray = this.input.getValues();
            double[] dArray2 = this.output.getValues();
            for (int i = n; i < n2; ++i) {
                double d = dArray[i];
                this.audioBuffer[this.audioBufferCursor] = dArray[i];
                ++this.audioBufferCursor;
                if (this.audioBufferCursor == this.audioBuffer.length) {
                    boolean bl = this.detect(this.audioBuffer);
                    this.current.set(bl ? 1.0 : 0.0);
                    this.audioBufferCursor = 0;
                }
                dArray2[i] = d;
            }
        }

        private boolean detect(double[] dArray) {
            float f = 0.0f;
            for (int i = 0; i < dArray.length; ++i) {
                f = (float)((double)f + dArray[i] * dArray[i]);
            }
            f /= (float)dArray.length;
            f = (float)Math.sqrt(f);
            float f2 = f * 100.0f;
            float f3 = this.average(this.energyBuffer);
            float f4 = this.variance(this.energyBuffer, f3);
            float f5 = -0.0025714f * f4 + 1.5142857f;
            float f6 = Math.max(f2 - f5 * f3, 0.0f);
            float f7 = this.specAverage(this.deltaBuffer);
            float f8 = Math.max(f6 - f7, 0.0f);
            boolean bl = false;
            if ((double)(this.detectTimeMillis - this.sensitivityTimer) < this.sensitivity.get()) {
                bl = false;
            } else if (f8 > 0.0f && f2 > 2.0f) {
                bl = true;
                this.sensitivityTimer = this.detectTimeMillis;
            } else {
                bl = false;
            }
            this.energyBuffer[this.energyBufferCursor] = f2;
            this.deltaBuffer[this.energyBufferCursor] = f6;
            this.beatBuffer[this.energyBufferCursor] = bl;
            ++this.energyBufferCursor;
            if (this.energyBufferCursor == this.energyBuffer.length) {
                this.energyBufferCursor = 0;
            }
            this.detectTimeMillis += (long)((float)dArray.length / (float)this.getFrameRate() * 1000.0f);
            return bl;
        }

        private float average(double[] dArray) {
            float f = 0.0f;
            for (int i = 0; i < dArray.length; ++i) {
                f = (float)((double)f + dArray[i]);
            }
            return f /= (float)dArray.length;
        }

        private float specAverage(double[] dArray) {
            float f = 0.0f;
            float f2 = 0.0f;
            for (int i = 0; i < dArray.length; ++i) {
                if (!(dArray[i] > 0.0)) continue;
                f = (float)((double)f + dArray[i]);
                f2 += 1.0f;
            }
            if (f2 > 0.0f) {
                f /= f2;
            }
            return f;
        }

        private float variance(double[] dArray, float f) {
            float f2 = 0.0f;
            for (int i = 0; i < dArray.length; ++i) {
                f2 += (float)Math.pow(dArray[i] - (double)f, 2.0);
            }
            return f2 /= (float)dArray.length;
        }

        public double[] getEnergyBuffer() {
            return this.energyBuffer;
        }

        public double[] getDeltaBuffer() {
            return this.deltaBuffer;
        }

        public boolean[] getBeatBuffer() {
            return this.beatBuffer;
        }

        public int getEnergyCursor() {
            return this.energyBufferCursor;
        }
    }
}

