/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.Circuit;
import com.jsyn.unitgen.Delay;
import com.jsyn.unitgen.FilterOnePole;
import com.jsyn.unitgen.MultiplyAdd;
import com.jsyn.unitgen.PassThrough;

class JSynLBCF
extends Circuit {
    protected UnitInputPort input;
    protected UnitOutputPort output;
    private MultiplyAdd mixer;
    private Delay delay;
    private FilterOnePole filter;

    public JSynLBCF(double d, double d2, int n) {
        PassThrough passThrough = new PassThrough();
        this.add(passThrough);
        this.mixer = new MultiplyAdd();
        this.add(this.mixer);
        this.setF(d);
        this.filter = new FilterOnePole();
        this.add(this.filter);
        this.setD(d2);
        this.delay = new Delay();
        this.add(this.delay);
        this.delay.allocate(n);
        this.input = passThrough.input;
        passThrough.output.connect(this.delay.input);
        this.delay.output.connect(this.filter.input);
        this.filter.output.connect(this.mixer.inputB);
        this.output = this.mixer.output;
    }

    protected void setD(double d) {
        this.filter.a0.setValue(1.0 - d);
        this.filter.b1.setValue(-d);
    }

    protected void setF(double d) {
        this.mixer.inputA.set(d);
    }
}

