/*
 * Decompiled with CFR 0.152.
 */
package processing.sound;

import com.jsyn.data.FloatSample;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.FixedRateMonoWriter;
import processing.core.PApplet;
import processing.sound.Analyzer;
import processing.sound.Engine;
import processing.sound.SoundObject;

public class Waveform
extends Analyzer {
    public float[] data;
    private FixedRateMonoWriter writer;
    private FloatSample buffer;
    private int lastAnalysisOffset;

    public Waveform(PApplet pApplet, int n) {
        super(pApplet);
        if (n <= 0) {
            Engine.printError("number of waveform frames needs to be greater than 0");
        } else {
            this.data = new float[n];
            this.writer = new FixedRateMonoWriter();
            this.buffer = new FloatSample(n);
            this.writer.dataQueue.queueLoop(this.buffer);
        }
    }

    @Override
    protected void removeInput() {
        this.writer.input.disconnectAll();
        this.input = null;
    }

    @Override
    protected void setInput(UnitOutputPort unitOutputPort) {
        Engine.getEngine().add(this.writer);
        this.writer.input.connect(unitOutputPort);
        this.writer.start();
    }

    public float[] analyze() {
        return this.analyze(this.data);
    }

    public float[] analyze(float[] fArray) {
        if (this.input == null) {
            Engine.printWarning("this Waveform has no sound source connected to it, nothing to analyze");
        }
        this.lastAnalysisOffset = (int)this.writer.dataQueue.getFrameCount() % this.buffer.getNumFrames();
        this.buffer.read(this.lastAnalysisOffset, fArray, 0, this.buffer.getNumFrames() - this.lastAnalysisOffset);
        this.buffer.read(0, fArray, this.buffer.getNumFrames() - this.lastAnalysisOffset, this.lastAnalysisOffset);
        return fArray;
    }

    @Override
    public void input(SoundObject soundObject) {
        super.input(soundObject);
    }
}

